<?php
require_once __DIR__ . '/../includes/auth.php';
$active    = 'tenants';
$pageTitle = 'Tenants';

$db = hub_db();
$rows = $db->query("SELECT * FROM tenants ORDER BY id DESC")->fetchAll();

// ---- Kota ayarları (env ile override edilebilir) ----
$c = hub_config();
$PLAN_LIMITS = [
  'free'  => isset($c['PLAN_LIMIT_FREE'])  ? (int)$c['PLAN_LIMIT_FREE']  : 5,
  'basic' => isset($c['PLAN_LIMIT_BASIC']) ? (int)$c['PLAN_LIMIT_BASIC'] : 100,
  'pro'   => null, // sınırsız
];

// ---- Yardımcı: tenant DB'ye bağlanıp fatura adedini say ----
function tenant_invoice_count(array $tenant): ?int {
    try {
        $dsn = "mysql:host={$tenant['db_host']};port={$tenant['db_port']};dbname={$tenant['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $tenant['db_user'], $tenant['db_pass'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        $cnt = $pdo->query("SELECT COUNT(*) FROM invoices")->fetchColumn();
        return ($cnt === false) ? 0 : (int)$cnt;
    } catch (Throwable $e) {
        // tablo yok, bağlantı hatası vs.
        return null;
    }
}

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Tenants</h3>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-primary" href="<?= h(base_url('tenants/bulk.php')) ?>"><i class="bi bi-layers"></i> Toplu</a>
    <a class="btn btn-primary" href="<?= h(base_url('tenants/add.php')) ?>"><i class="bi bi-plus-circle"></i> Yeni Tenant</a>
  </div>
</div>

<div class="card">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-striped table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Ad</th>
            <th>Domain</th>
            <th>Yöntem</th>
            <th>Abonelik</th>
            <th>Fatura</th>
            <th>API</th>
            <th>Aktif</th>
            <th>Son Uygulama</th>
            <th class="text-end">İşlemler</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
          <?php
            $method = $r['apply_method'] ?? 'db';
            $plan   = $r['subscription_type'] ?? 'free';
            $limit  = $PLAN_LIMITS[$plan] ?? null;

            // --- Fatura kullanım metni ---
            $invCount = tenant_invoice_count($r);
            if ($invCount === null) {
                $usageHtml = '<span class="badge bg-secondary" title="Bağlantı/erişim hatası">N/A</span>';
            } else {
                $usageText = ($limit === null) ? ($invCount . '/&infin;') : ($invCount . '/' . (int)$limit);
                $usageHtml = '<span class="badge bg-light text-dark">'.$usageText.'</span>';
            }

            // --- API hücresi görselleştirme ---
            $apiUrl = trim((string)($r['api_base_url'] ?? ''));
            $apiKey = trim((string)($r['api_key'] ?? ''));
            if ($method === 'api') {
                if ($apiUrl !== '' && $apiKey !== '') {
                    $short = preg_replace('~^https?://~', '', $apiUrl);
                    if (mb_strlen($short, 'UTF-8') > 30) {
                        $short = mb_substr($short, 0, 27, 'UTF-8') . '…';
                    }
                    $apiCell = '<span class="badge bg-success" title="'.h($apiUrl).'">Bağlı</span>'
                             . '<small class="text-muted d-block">'.h($short).'</small>';
                } elseif ($apiUrl !== '' && $apiKey === '') {
                    $apiCell = '<span class="badge bg-warning text-dark" title="API Key eksik">Key yok</span>';
                } elseif ($apiUrl === '' && $apiKey !== '') {
                    $apiCell = '<span class="badge bg-warning text-dark" title="API Base URL eksik">URL yok</span>';
                } else {
                    $apiCell = '<span class="badge bg-secondary" title="API URL ve Key tanımsız">Tanımsız</span>';
                }
            } else {
                $apiCell = '<span class="badge bg-light text-dark" title="Uygulama yöntemi DB: AdminHub doğrudan tenant veritabanına yazar">DB</span>';
            }
          ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= h($r['name']) ?></td>
            <td><?= h($r['domain']) ?></td>
            <td><span class="badge bg-secondary"><?= h($method) ?></span></td>
            <td><?= h($plan) ?><?= !empty($r['subscription_end']) ? ' / '.h($r['subscription_end']) : '' ?></td>
            <td><?= $usageHtml ?></td>
            <td><?= $apiCell ?></td>
            <td><?= (int)$r['is_active'] ? '<span class="badge bg-success">Aktif</span>' : '<span class="badge bg-secondary">Pasif</span>' ?></td>
            <td><?= h($r['last_applied_at'] ?? '') ?></td>
            <td class="text-end">
              <div class="btn-group" role="group">
                <a class="btn btn-sm btn-outline-info" href="<?= h(base_url('tenants/health.php?id='.(int)$r['id'])) ?>"><i class="bi bi-heart-pulse"></i> Health</a>
                <a class="btn btn-sm btn-outline-secondary" href="<?= h(base_url('tenants/edit.php?id='.(int)$r['id'])) ?>"><i class="bi bi-pencil"></i> Düzenle</a>
                <a class="btn btn-sm btn-success" href="<?= h(base_url('tenants/apply.php?id='.(int)$r['id'])) ?>"><i class="bi bi-check2-circle"></i> Uygula</a>
              </div>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
