<?php
require_once __DIR__ . '/../includes/auth.php'; // güvenli giriş
$active    = 'tenants';
$pageTitle = 'Tenant Health';

$id = (int)($_GET['id'] ?? 0);
$t  = get_tenant($id);
if (!$t) { http_response_code(404); echo "Tenant yok"; exit; }

$mode  = $t['apply_method'];
$err   = '';
$data  = null;

try {
    if ($mode === 'api' && !empty($t['api_base_url']) && !empty($t['api_key'])) {
        $url  = rtrim($t['api_base_url'],'/') . '/api/health.php';
        $opts = [
          'http' => [
            'method'  => 'GET',
            'header'  => "X-API-Key: {$t['api_key']}\r\n",
            'timeout' => 15
          ]
        ];
        $res = @file_get_contents($url, false, stream_context_create($opts));
        if ($res === false) {
            throw new RuntimeException('API çağrısı başarısız');
        }
        $j = json_decode($res, true);
        if (!is_array($j)) {
            throw new RuntimeException('Geçersiz JSON');
        }
        $data = $j;
    } else {
        // DB üstünden basit sağlık kontrolü
        $dsn = "mysql:host={$t['db_host']};port={$t['db_port']};dbname={$t['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $t['db_user'], $t['db_pass'], [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        $pdo->query("SELECT 1");
        $app = $pdo->query("
            SELECT k,v FROM app_settings
            WHERE k IN ('SUBSCRIPTION_TYPE','SUBSCRIPTION_END','LAST_CRON_DAILY','LAST_CRON_HOURLY','SITE_URL')
        ")->fetchAll(PDO::FETCH_KEY_PAIR);

        $data = [
          'ok'                => true,
          'php_version'       => PHP_VERSION,
          'db'                => true,
          'site_url'          => $app['SITE_URL'] ?? $t['domain'],
          'subscription_type' => $app['SUBSCRIPTION_TYPE'] ?? 'free',
          'subscription_end'  => $app['SUBSCRIPTION_END']  ?? null,
          'cron' => [
            'last_daily'  => $app['LAST_CRON_DAILY']  ?? null,
            'last_hourly' => $app['LAST_CRON_HOURLY'] ?? null,
          ],
        ];
    }
} catch (Throwable $e) {
    $err = $e->getMessage();
}

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Health: <?= h($t['name']) ?></h3>
  <a class="btn btn-secondary" href="<?= h(base_url('tenants/index.php')) ?>"><i class="bi bi-arrow-left"></i> Geri</a>
</div>

<?php if ($err): ?>
  <div class="alert alert-danger">Hata: <?= h($err) ?></div>
<?php else: ?>
  <div class="card">
    <div class="card-body">
      <pre class="bg-light p-3 border rounded" style="white-space:pre-wrap"><?= h(json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) ?></pre>
    </div>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>
