<?php
require_once __DIR__ . '/../includes/auth.php';

$db = hub_db();
$id = (int)($_GET['id'] ?? 0);
$t  = get_tenant($id);
if (!$t) { http_response_code(404); echo "Tenant yok"; exit; }
if (!(int)$t['is_active']) { flash_set('err','Tenant pasif.'); header('Location: ' . base_url('tenants/index.php')); exit; }

try {
    if ($t['apply_method'] === 'api') {
        apply_by_api($t);
    } else {
        apply_by_db($t);
    }
    $db->prepare("UPDATE tenants SET last_applied_at=NOW() WHERE id=?")->execute([$id]);
    log_tenant($id, 'apply', 'success', 'Ayarlar uygulandı');
    flash_set('ok','Ayarlar uygulandı.');
    header('Location: ' . base_url('tenants/index.php'));
    exit;
} catch(Throwable $e) {
    log_tenant($id, 'apply', 'error', $e->getMessage());
    flash_set('err','Hata: ' . $e->getMessage());
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}
