<?php
require_once __DIR__ . '/../includes/functions.php';
$c = hub_config();
$db = hub_db();

$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    try {
        $p = $_POST;

        // Boş stringleri NULL yapalım
        $subscription_end = ($p['subscription_end'] ?? '') ?: null;
        $api_base_url     = ($p['api_base_url'] ?? '') ?: null;
        $api_key          = ($p['api_key'] ?? '') ?: null;

        // apply_method=api ve api_key boşsa otomatik üret
        $apply_method = $p['apply_method'] ?? 'db';
        if ($apply_method === 'api' && $api_key === '') {
            $api_key = generate_api_key();
            flash_set('ok', 'API Key otomatik üretildi.');
        }

        // Checkbox -> 1/0
        $mods = [
          'module_invoices','module_customers','module_products','module_inventory','module_production',
          'module_personnel','module_crm','module_accounts','module_budget','module_cheques',
          'module_expenses','module_tax','module_efatura','module_eirsaliye','module_foreign_trade','module_reports' // YENİLER eklendi
        ];
        $mvals = [];
        foreach ($mods as $m) { $mvals[$m] = isset($p[$m]) ? 1 : 0; }

        $sql = "INSERT INTO tenants
          (name, domain,
           db_host, db_port, db_name, db_user, db_pass,
           subscription_type, subscription_end,
           module_invoices, module_customers, module_products, module_inventory, module_production, module_personnel, module_crm, module_accounts, module_budget, module_cheques, module_expenses, module_tax, module_efatura, module_eirsaliye, module_foreign_trade, module_reports,
           apply_method, api_base_url, api_key, is_active)
          VALUES
          (:name, :domain,
           :db_host, :db_port, :db_name, :db_user, :db_pass,
           :subscription_type, :subscription_end,
           :module_invoices, :module_customers, :module_products, :module_inventory, :module_production, :module_personnel, :module_crm, :module_accounts, :module_budget, :module_cheques, :module_expenses, :module_tax, :module_efatura, :module_eirsaliye, :module_foreign_trade, :module_reports,
           :apply_method, :api_base_url, :api_key, :is_active)";

        $st = $db->prepare($sql);
        $st->execute([
          ':name' => $p['name'],
          ':domain' => $p['domain'],

          ':db_host' => $p['db_host'],
          ':db_port' => (int)$p['db_port'],
          ':db_name' => $p['db_name'],
          ':db_user' => $p['db_user'],
          ':db_pass' => $p['db_pass'],

          ':subscription_type' => $p['subscription_type'] ?? 'free',
          ':subscription_end'  => $subscription_end,

          ':module_invoices'      => $mvals['module_invoices'],
          ':module_customers'     => $mvals['module_customers'],
          ':module_products'      => $mvals['module_products'],
          ':module_inventory'     => $mvals['module_inventory'],
          ':module_production'    => $mvals['module_production'],
          ':module_personnel'     => $mvals['module_personnel'],
          ':module_crm'           => $mvals['module_crm'],
          ':module_accounts'      => $mvals['module_accounts'],
          ':module_budget'        => $mvals['module_budget'],
          ':module_cheques'       => $mvals['module_cheques'],
          ':module_expenses'      => $mvals['module_expenses'],
          ':module_tax'           => $mvals['module_tax'],
          ':module_efatura'       => $mvals['module_efatura'],
          ':module_eirsaliye'     => $mvals['module_eirsaliye'],     // YENİ
          ':module_foreign_trade' => $mvals['module_foreign_trade'], // YENİ
          ':module_reports'       => $mvals['module_reports'],

          ':apply_method' => $apply_method,
          ':api_base_url' => $api_base_url,
          ':api_key'      => $api_key ?: null,
          ':is_active'    => isset($p['is_active']) ? 1 : 0,
        ]);

        header('Location: index.php');
        exit;
    } catch(Throwable $e) {
        $err = $e->getMessage();
    }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <title>Yeni Tenant - <?=h($c['SITE_NAME'])?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-3">
<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Yeni Tenant</h3>
    <a class="btn btn-secondary" href="index.php">Geri</a>
  </div>

  <?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Ad</label>
      <input name="name" class="form-control" required>
    </div>
    <div class="col-md-8">
      <label class="form-label">Domain</label>
      <input name="domain" class="form-control" placeholder="https://fatura.ornek.com" required>
    </div>

    <h5 class="mt-4">Tenant DB</h5>
    <div class="col-md-4"><label class="form-label">Host</label><input name="db_host" class="form-control" value="127.0.0.1" required></div>
    <div class="col-md-2"><label class="form-label">Port</label><input name="db_port" type="number" class="form-control" value="3306" required></div>
    <div class="col-md-3"><label class="form-label">DB Name</label><input name="db_name" class="form-control" required></div>
    <div class="col-md-3"><label class="form-label">DB User</label><input name="db_user" class="form-control" required></div>
    <div class="col-md-6"><label class="form-label">DB Pass</label><input name="db_pass" type="password" class="form-control" required></div>

    <h5 class="mt-4">Abonelik</h5>
    <div class="col-md-3">
      <label class="form-label">Tip</label>
      <select name="subscription_type" class="form-select">
        <option value="free">free</option>
        <option value="basic">basic</option>
        <option value="pro">pro</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Bitiş (ops.)</label>
      <input type="date" name="subscription_end" class="form-control">
    </div>

    <h5 class="mt-4">Modüller</h5>
    <?php
      $mods = ['invoices','customers','products','inventory','production','personnel','crm','accounts','budget','cheques','expenses','tax','efatura','eirsaliye','foreign_trade','reports'];
      foreach($mods as $m): ?>
      <div class="col-md-3 form-check">
        <input class="form-check-input" type="checkbox" name="module_<?= $m ?>" id="m_<?= $m ?>" <?= in_array($m,['invoices','customers','products','inventory','reports'])?'checked':''; ?>>
        <label class="form-check-label" for="m_<?= $m ?>"><?= strtoupper(str_replace('_',' ',$m)) ?></label>
      </div>
    <?php endforeach; ?>

    <h5 class="mt-4">Uygulama Yöntemi / API</h5>
    <div class="col-md-3">
      <label class="form-label">Yöntem</label>
      <select name="apply_method" class="form-select">
        <option value="db">DB (doğrudan)</option>
        <option value="api">API (tenant/api/set_config.php)</option>
      </select>
    </div>
    <div class="col-md-5">
      <label class="form-label">API Base URL</label>
      <input name="api_base_url" class="form-control" placeholder="https://fatura.ornek.com">
    </div>
    <div class="col-md-4">
      <label class="form-label">API Key (boşsa otomatik üretilecek)</label>
      <input name="api_key" class="form-control" placeholder="sk-...">
    </div>

    <div class="col-12 form-check mt-3">
      <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
      <label class="form-check-label" for="is_active">Aktif</label>
    </div>

    <div class="col-12 mt-3">
      <button class="btn btn-primary">Kaydet</button>
      <a class="btn btn-secondary" href="index.php">Geri</a>
    </div>
  </form>
</div>
</body>
</html>
