<?php
require_once __DIR__ . '/includes/auth.php';
$active    = 'dashboard';
$pageTitle = 'Dashboard';

// Kısa metrikler
$db        = hub_db();
$total     = (int)$db->query("SELECT COUNT(*) c FROM tenants")->fetch()['c'];
$activeCnt = (int)$db->query("SELECT COUNT(*) c FROM tenants WHERE is_active=1")->fetch()['c'];
$apiCnt    = (int)$db->query("SELECT COUNT(*) c FROM tenants WHERE apply_method='api'")->fetch()['c'];
$dbCnt     = (int)$db->query("SELECT COUNT(*) c FROM tenants WHERE apply_method='db'")->fetch()['c'];

$recentLogs = $db->query("
  SELECT tl.*, t.name AS tenant_name
  FROM tenant_logs tl
  JOIN tenants t ON t.id=tl.tenant_id
  ORDER BY tl.id DESC
  LIMIT 12
")->fetchAll();

include __DIR__ . '/includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-md-3">
    <div class="card stat p-3">
      <div class="text-muted">Toplam Tenant</div>
      <div class="fs-3 fw-bold"><?= $total ?></div>
    </div>
  </div>
  <div class="col-12 col-md-3">
    <div class="card stat p-3">
      <div class="text-muted">Aktif</div>
      <div class="fs-3 fw-bold text-success"><?= $activeCnt ?></div>
    </div>
  </div>
  <div class="col-12 col-md-3">
    <div class="card stat p-3">
      <div class="text-muted">Uygulama: DB</div>
      <div class="fs-3 fw-bold"><?= $dbCnt ?></div>
    </div>
  </div>
  <div class="col-12 col-md-3">
    <div class="card stat p-3">
      <div class="text-muted">Uygulama: API</div>
      <div class="fs-3 fw-bold"><?= $apiCnt ?></div>
    </div>
  </div>
</div>

<div class="row g-3 mt-2">
  <div class="col-lg-8">
    <div class="card">
      <div class="card-header"><strong>Son İşlemler</strong></div>
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover mb-0">
            <thead class="table-light">
              <tr><th>#</th><th>Tenant</th><th>Aksiyon</th><th>Durum</th><th>Mesaj</th><th>Zaman</th></tr>
            </thead>
            <tbody>
            <?php if (!$recentLogs): ?>
              <tr><td colspan="6" class="text-center text-muted py-4">Kayıt yok.</td></tr>
            <?php else: foreach ($recentLogs as $r): ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td><?= h($r['tenant_name']) ?></td>
                <td><?= h($r['action']) ?></td>
                <td>
                  <?php if ($r['status']==='success'): ?>
                    <span class="badge bg-success">success</span>
                  <?php else: ?>
                    <span class="badge bg-danger">error</span>
                  <?php endif; ?>
                </td>
                <td><?= h(mb_strimwidth((string)$r['message'], 0, 120, '…', 'UTF-8')) ?></td>
                <td><?= h($r['created_at']) ?></td>
              </tr>
            <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
      <div class="card-footer text-end">
        <a href="<?= h(base_url('tenants/index.php')) ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-buildings"></i> Tenants</a>
      </div>
    </div>
  </div>

  <div class="col-lg-4">
    <div class="card">
      <div class="card-header"><strong>Hızlı İşlemler</strong></div>
      <div class="card-body">
        <a href="<?= h(base_url('tenants/add.php')) ?>" class="btn btn-primary w-100 mb-2"><i class="bi bi-plus-circle"></i> Yeni Tenant</a>
        <a href="<?= h(base_url('tenants/index.php')) ?>" class="btn btn-outline-secondary w-100"><i class="bi bi-list-ul"></i> Tüm Tenantlar</a>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
