<?php
// AdminHub -> config/database.php
function hub_config(): array {
    static $cfg;
    if ($cfg) return $cfg;
    $cfg = require __DIR__ . '/env.php';

    // Errors
    if (($cfg['DISPLAY_ERRORS'] ?? '0') === '1') {
        @ini_set('display_errors', '1');
        @error_reporting(E_ALL);
    } else {
        @ini_set('display_errors', '0');
        @error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
    }

    // Session name
    if (!empty($cfg['SESSION_NAME']) && session_status() === PHP_SESSION_NONE) {
        session_name($cfg['SESSION_NAME']);
    }
    return $cfg;
}

function hub_db(): PDO {
    static $pdo;
    if ($pdo) return $pdo;
    $c = hub_config();
    $dsn = "mysql:host={$c['DB_HOST']};port={$c['DB_PORT']};dbname={$c['DB_NAME']};charset=" . ($c['DB_CHARSET'] ?? 'utf8mb4');
    $pdo = new PDO($dsn, $c['DB_USER'], $c['DB_PASS'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    return $pdo;
}
