<?php
require_once __DIR__ . '/../includes/functions.php';

if (is_admin()) { header('Location: ' . base_url('index.php')); exit; }

$c = hub_config();
$err = '';

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err = 'Güvenlik doğrulaması başarısız.';
    } else {
        $email = trim($_POST['email'] ?? '');
        $pass  = (string)($_POST['password'] ?? '');
        if ($email === '' || $pass === '') {
            $err = 'E-posta ve şifre zorunludur.';
        } else {
            if (attempt_login($email, $pass)) {
                flash_set('ok','Hoş geldiniz!');
                header('Location: ' . base_url('index.php'));
                exit;
            } else {
                $err = 'Hatalı e-posta veya şifre (veya geçici engel).';
            }
        }
    }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <title>Admin Giriş - <?= h($c['SITE_NAME']) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="robots" content="noindex,nofollow">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: linear-gradient(135deg,#111,#222); color:#fff; }
    .login-card { max-width:420px; margin:10vh auto; background:#fff; color:#333; border-radius:16px; box-shadow:0 10px 30px rgba(0,0,0,.35); }
    .brand { font-weight:700; letter-spacing:.3px; }
  </style>
</head>
<body>
<div class="login-card p-4">
  <div class="text-center mb-3">
    <div class="brand fs-4">🔐 <?= h($c['SITE_NAME']) ?></div>
    <div class="text-muted">Yönetici Girişi</div>
  </div>
  <?php if ($err): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
  <form method="post" novalidate>
    <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
    <div class="mb-3">
      <label class="form-label">E-posta</label>
      <input type="email" name="email" class="form-control" required autofocus>
    </div>
    <div class="mb-3">
      <label class="form-label">Şifre</label>
      <input type="password" name="password" class="form-control" required>
    </div>
    <button class="btn btn-primary w-100">Giriş yap</button>
  </form>
  <div class="text-center text-muted mt-3"><small>3. taraf çerezler kapalıysa giriş sorun yaşayabilir.</small></div>
</div>
</body>
</html>
