<?php
require_once __DIR__ . '/../includes/auth.php'; // güvenli giriş
$active    = 'tenants';
$pageTitle = 'Tenant Health';

$id = (int)($_GET['id'] ?? 0);
$t  = get_tenant($id);
if (!$t) { http_response_code(404); echo "Tenant yok"; exit; }

// Beklenen modüller (AdminHub tarafı)
$expected = [
  'invoices'       => (bool)$t['module_invoices'],
  'customers'      => (bool)$t['module_customers'],
  'products'       => (bool)$t['module_products'],
  'inventory'      => (bool)$t['module_inventory'],
  'production'     => (bool)$t['module_production'],
  'personnel'      => (bool)$t['module_personnel'],
  'crm'            => (bool)$t['module_crm'],
  'accounts'       => (bool)$t['module_accounts'],
  'budget'         => (bool)$t['module_budget'],
  'cheques'        => (bool)$t['module_cheques'],
  'expenses'       => (bool)$t['module_expenses'],
  'tax'            => (bool)$t['module_tax'],
  'efatura'        => (bool)$t['module_efatura'],
  'eirsaliye'      => (bool)($t['module_eirsaliye'] ?? 0),
  'irsaliye'       => (bool)($t['module_irsaliye']   ?? 0),
  'deliveries'     => (bool)($t['module_deliveries'] ?? 0),
  'foreign_trade'  => (bool)($t['module_foreign_trade'] ?? 0),
  'orders'         => (bool)($t['module_orders'] ?? 0),
  'reports'        => (bool)$t['module_reports'],
];

$mode  = $t['apply_method'];
$err   = '';
$data  = null;

try {
    if ($mode === 'api' && !empty($t['api_base_url']) && !empty($t['api_key'])) {
        $url  = rtrim($t['api_base_url'],'/') . '/api/health.php';
        $opts = [
          'http' => [
            'method'  => 'GET',
            'header'  => "X-API-Key: {$t['api_key']}\r\n",
            'timeout' => 15
          ]
        ];
        $res = @file_get_contents($url, false, stream_context_create($opts));
        if ($res === false) {
            throw new RuntimeException('API çağrısı başarısız');
        }
        $j = json_decode($res, true);
        if (!is_array($j)) {
            throw new RuntimeException('Geçersiz JSON');
        }

        $actual = is_array($j['modules'] ?? null) ? array_map('boolval', $j['modules']) : null;
        $diff = [];
        if (is_array($actual)) {
            foreach ($expected as $k=>$v) {
                if (isset($actual[$k]) && (bool)$actual[$k] !== (bool)$v) {
                    $diff[$k] = ['expected'=>$v, 'actual'=>(bool)$actual[$k]];
                }
            }
        }

        $data = [
          'ok'        => (bool)($j['ok'] ?? false),
          'php'       => $j['php_version'] ?? null,
          'site_url'  => $j['site_url'] ?? ($t['domain'] ?? null),
          'subscription_type' => $j['subscription_type'] ?? null,
          'subscription_end'  => $j['subscription_end'] ?? null,
          'modules_expected'  => $expected,
          'modules_actual'    => $actual,
          'modules_diff'      => $diff,
          'raw'               => $j,
        ];
    } else {
        // DB üstünden sağlık kontrolü + modüller
        $dsn = "mysql:host={$t['db_host']};port={$t['db_port']};dbname={$t['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $t['db_user'], $t['db_pass'], [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        $pdo->query("SELECT 1");
        $app = $pdo->query("
            SELECT k,v FROM app_settings
            WHERE k IN (
              'SUBSCRIPTION_TYPE','SUBSCRIPTION_END','LAST_CRON_DAILY','LAST_CRON_HOURLY','SITE_URL',
              'MODULE_INVOICES','MODULE_CUSTOMERS','MODULE_PRODUCTS','MODULE_INVENTORY','MODULE_PRODUCTION',
              'MODULE_PERSONNEL','MODULE_CRM','MODULE_ACCOUNTS','MODULE_BUDGET','MODULE_CHEQUES',
              'MODULE_EXPENSES','MODULE_TAX','MODULE_EFATURA','MODULE_EIRSALIYE','MODULE_IRSALIYE',
              'MODULE_DELIVERIES','MODULE_FOREIGN_TRADE','MODULE_ORDERS','MODULE_REPORTS'
            )
        ")->fetchAll(PDO::FETCH_KEY_PAIR);

        $b = fn($k) => isset($app[$k]) && (string)$app[$k] === '1';
        $actual = [
          'invoices'=>$b('MODULE_INVOICES'),'customers'=>$b('MODULE_CUSTOMERS'),'products'=>$b('MODULE_PRODUCTS'),
          'inventory'=>$b('MODULE_INVENTORY'),'production'=>$b('MODULE_PRODUCTION'),'personnel'=>$b('MODULE_PERSONNEL'),
          'crm'=>$b('MODULE_CRM'),'accounts'=>$b('MODULE_ACCOUNTS'),'budget'=>$b('MODULE_BUDGET'),
          'cheques'=>$b('MODULE_CHEQUES'),'expenses'=>$b('MODULE_EXPENSES'),'tax'=>$b('MODULE_TAX'),
          'efatura'=>$b('MODULE_EFATURA'),'eirsaliye'=>$b('MODULE_EIRSALIYE'),'irsaliye'=>$b('MODULE_IRSALIYE'),
          'deliveries'=>$b('MODULE_DELIVERIES'),'foreign_trade'=>$b('MODULE_FOREIGN_TRADE'),
          'orders'=>$b('MODULE_ORDERS'),'reports'=>$b('MODULE_REPORTS'),
        ];

        $diff = [];
        foreach ($expected as $k=>$v) {
            if ((bool)$actual[$k] !== (bool)$v) {
                $diff[$k] = ['expected'=>$v, 'actual'=>(bool)$actual[$k]];
            }
        }

        $data = [
          'ok'                => true,
          'php_version'       => PHP_VERSION,
          'db'                => true,
          'site_url'          => $app['SITE_URL'] ?? $t['domain'],
          'subscription_type' => $app['SUBSCRIPTION_TYPE'] ?? ($t['subscription_type'] ?? 'free'),
          'subscription_end'  => $app['SUBSCRIPTION_END']  ?? ($t['subscription_end'] ?? null),
          'cron' => [
            'last_daily'  => $app['LAST_CRON_DAILY']  ?? null,
            'last_hourly' => $app['LAST_CRON_HOURLY'] ?? null,
          ],
          'modules_expected'  => $expected,
          'modules_actual'    => $actual,
          'modules_diff'      => $diff,
        ];
    }
} catch (Throwable $e) {
    $err = $e->getMessage();
}

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Health: <?= h($t['name']) ?></h3>
  <a class="btn btn-secondary" href="<?= h(base_url('tenants/index.php')) ?>"><i class="bi bi-arrow-left"></i> Geri</a>
</div>

<?php if ($err): ?>
  <div class="alert alert-danger">Hata: <?= h($err) ?></div>
<?php else: ?>
  <div class="card">
    <div class="card-body">
      <pre class="bg-light p-3 border rounded" style="white-space:pre-wrap"><?= h(json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) ?></pre>
    </div>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>
