<?php
// tenants/apply.php
require_once __DIR__ . '/../includes/auth.php';

$db = hub_db();
$id = (int)($_GET['id'] ?? 0);

if ($id <= 0) {
    flash_set('err','Geçersiz istek.');
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}

$t  = get_tenant($id);
if (!$t) {
    http_response_code(404);
    echo "Tenant yok";
    exit;
}

if (!(int)$t['is_active']) {
    flash_set('err','Tenant pasif.');
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}

try {
    $method = (string)($t['apply_method'] ?? 'db');

    if ($method === 'api') {
        // API ile uygulama için temel doğrulamalar
        $apiBase = trim((string)($t['api_base_url'] ?? ''));
        $apiKey  = trim((string)($t['api_key'] ?? ''));
        if ($apiBase === '' || $apiKey === '') {
            throw new RuntimeException('API ile uygulama için api_base_url veya api_key eksik.');
        }
        apply_by_api($t);
    } else {
        // Varsayılan doğrudan DB uygulama
        apply_by_db($t);
    }

    // Son uygulama zamanını güncelle
    $db->prepare("UPDATE tenants SET last_applied_at = NOW() WHERE id = ?")->execute([$id]);

    // Log + kullanıcı mesajı
    log_tenant($id, 'apply', 'success', 'Ayarlar uygulandı (yöntem: ' . $method . ')');
    flash_set('ok','Ayarlar uygulandı (yöntem: ' . h($method) . ').');
    header('Location: ' . base_url('tenants/index.php'));
    exit;

} catch (Throwable $e) {
    // Hata logla ve kullanıcıya bildir
    log_tenant($id, 'apply', 'error', $e->getMessage());
    flash_set('err','Hata: ' . $e->getMessage());
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}
