<?php
// adminhub/tenants/sync_menu.php
// AdminHub'daki data/menu.json içeriğini tüm aktif tenantlara gönderir

require_once __DIR__ . '/../includes/auth.php';      // kullanıcı oturumu + izinler
require_once __DIR__ . '/../includes/functions.php'; // hub_db, hub_config vs.

$db = hub_db();
$c  = hub_config();

$pageTitle = 'Menü Eşitle (Deployment)';
$active    = 'tenants';

// 1) AdminHub tarafındaki menu.json dosyasını oku
// NOT: Artık adminhub/data/menu.json içinden okuyoruz
$menuFile = __DIR__ . '/../data/menu.json';
$menuStructure = [];
$loadError = '';

if (!file_exists($menuFile)) {
    $loadError = 'AdminHub menu.json dosyası bulunamadı: ' . h($menuFile);
} else {
    $json = file_get_contents($menuFile);
    $menuStructure = json_decode($json, true);
    if (!is_array($menuStructure)) {
        $loadError = 'AdminHub menu.json geçerli bir JSON değil veya dizi formatında değil.';
    }
}

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$loadError) {

    // Sadece aktif tenantlar
    $tenants = $db->query("SELECT * FROM tenants WHERE is_active = 1")->fetchAll();

    $success = 0;
    $fail    = 0;

    foreach ($tenants as $t) {
        // API bilgisi eksikse atla
        if (empty($t['api_base_url']) || empty($t['api_key'])) {
            $fail++;
            continue;
        }

        // Tenant tarafındaki endpoint: /api/sync_menu.php
        $url = rtrim($t['api_base_url'], '/') . '/api/sync_menu.php';

        $payload = [
            'menu_structure' => $menuStructure,
        ];

        $opts = [
            'http' => [
                'method'  => 'POST',
                'header'  => "Content-Type: application/json\r\nX-API-Key: {$t['api_key']}\r\n",
                'content' => json_encode($payload, JSON_UNESCAPED_UNICODE),
                'timeout' => 10,
            ],
        ];

        $context = stream_context_create($opts);
        $res     = @file_get_contents($url, false, $context);
        $jsonRes = json_decode($res ?: '', true);

        if ($jsonRes && ($jsonRes['ok'] ?? false)) {
            $success++;
        } else {
            $fail++;
        }
    }

    $msg = "İşlem tamamlandı: {$success} başarılı, {$fail} başarısız.";
}

include __DIR__ . '/../includes/header.php';
?>

<div class="card">
  <div class="card-header">
    Menü Tanımlarını Eşitle (Deployment)
  </div>
  <div class="card-body">
    <p>
      Bu işlem, <strong>AdminHub</strong> üzerindeki
      <code>data/menu.json</code> içeriğini
      tüm <strong>aktif tenant</strong>lara
      <code>/api/sync_menu.php</code> endpointi üzerinden gönderir.
    </p>
    <p class="text-info">
      <i class="bi bi-info-circle"></i>
      Tenant veritabanındaki modül açık/kapalı ayarlarına dokunmaz; sadece tenant tarafındaki
      <code>includes/menu.json</code> dosyasını günceller.
    </p>

    <?php if ($loadError): ?>
      <div class="alert alert-danger"><?= $loadError ?></div>
    <?php endif; ?>

    <?php if ($msg): ?>
      <div class="alert alert-info"><?= h($msg) ?></div>
    <?php endif; ?>

    <div class="bg-light p-3 mb-3 border" style="max-height:300px; overflow:auto;">
      <strong>Gönderilecek Menü Yapısı (AdminHub data/menu.json):</strong><br>
      <pre class="mb-0"><?= h(json_encode($menuStructure, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></pre>
    </div>

    <form method="post">
      <button class="btn btn-primary"
              <?= $loadError ? 'disabled' : '' ?>
              onclick="return confirm('Tüm aktif tenantlara gönderilsin mi?')">
        <i class="bi bi-cloud-upload"></i> Tümüne Gönder
      </button>
      <a href="<?= h(base_url('tenants/index.php')) ?>" class="btn btn-secondary">Geri</a>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
