<?php
// adminhub/tenants/sync_defs.php
require_once __DIR__ . '/../includes/auth.php'; // Registry burada yüklü
require_once __DIR__ . '/../includes/functions.php';

$db = hub_db();

// AdminHub'daki en güncel modül listesini al
$registry = hub_modules_registry();
$allModuleKeys = array_keys($registry); // ['invoices', 'crm', 'yeni_modul'...]

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sadece aktif tenantlar
    $tenants = $db->query("SELECT * FROM tenants WHERE is_active=1")->fetchAll();
    
    $success = 0;
    $fail = 0;

    foreach ($tenants as $t) {
        if (empty($t['api_base_url']) || empty($t['api_key'])) {
            $fail++; continue;
        }

        $url = rtrim($t['api_base_url'], '/') . '/api/sync_definitions.php';
        
        $payload = [
            'allowed_modules' => $allModuleKeys
        ];

        $opts = [
            'http' => [
                'method'  => 'POST',
                'header'  => "Content-Type: application/json\r\nX-API-Key: {$t['api_key']}\r\n",
                'content' => json_encode($payload),
                'timeout' => 5
            ]
        ];

        $res = @file_get_contents($url, false, stream_context_create($opts));
        $json = json_decode($res ?: '', true);

        if ($json && ($json['ok'] ?? false)) {
            $success++;
        } else {
            $fail++;
        }
    }
    
    $msg = "İşlem Tamamlandı: $success başarılı, $fail başarısız.";
}

include __DIR__ . '/../includes/header.php';
?>

<div class="card">
    <div class="card-header">
        Modül Tanımlarını Eşitle (Deployment)
    </div>
    <div class="card-body">
        <p>
            AdminHub üzerindeki güncel modül listesini (<strong><?= count($allModuleKeys) ?> adet</strong>) 
            tüm aktif müşterilere gönderir.
        </p>
        <p class="text-info">
            <i class="bi bi-info-circle"></i> Bu işlem müşterilerin veritabanındaki "açık/kapalı" ayarını bozmaz. 
            Sadece sistemin "tanıdığı" modül listesini günceller.
        </p>

        <?php if($msg): ?>
            <div class="alert alert-info"><?= h($msg) ?></div>
        <?php endif; ?>

        <div class="bg-light p-3 mb-3 border">
            <strong>Gönderilecek Liste:</strong><br>
            <code><?= implode(', ', $allModuleKeys) ?></code>
        </div>

        <form method="post">
            <button class="btn btn-primary" onclick="return confirm('Tüm müşterilere gönderilsin mi?')">
                <i class="bi bi-cloud-upload"></i> Tümüne Gönder
            </button>
            <a href="index.php" class="btn btn-secondary">Geri</a>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>