<?php
require_once __DIR__ . '/../includes/auth.php'; // includes/functions.php içinde modules_registry.php zaten çağrılıyor
$active    = 'tenants';
$pageTitle = 'Tenant Health';

$id = (int)($_GET['id'] ?? 0);
$t  = get_tenant($id);
if (!$t) { http_response_code(404); echo "Tenant yok"; exit; }

// Modül registry'si
$registry = hub_modules_registry();

// Beklenen modüller (AdminHub tarafı - Dinamik)
$expected = [];
foreach ($registry as $key => $cfg) {
    $expected[$cfg['api_field']] = (bool)($t[$cfg['tenant_column']] ?? 0);
}

$mode  = $t['apply_method'];
$err   = '';
$data  = null;

try {
    if ($mode === 'api' && !empty($t['api_base_url']) && !empty($t['api_key'])) {
        // --- API MODU ---
        $url  = rtrim($t['api_base_url'],'/') . '/api/health.php';
        $opts = [
          'http' => [
            'method'  => 'GET',
            'header'  => "X-API-Key: {$t['api_key']}\r\n",
            'timeout' => 15
          ]
        ];
        $res = @file_get_contents($url, false, stream_context_create($opts));
        if ($res === false) {
            throw new RuntimeException('API çağrısı başarısız');
        }
        $j = json_decode($res, true);
        if (!is_array($j)) {
            throw new RuntimeException('Geçersiz JSON');
        }

        $actual = is_array($j['modules'] ?? null) ? array_map('boolval', $j['modules']) : null;
        $diff = [];
        if (is_array($actual)) {
            foreach ($expected as $k=>$v) {
                if (isset($actual[$k]) && (bool)$actual[$k] !== (bool)$v) {
                    $diff[$k] = ['expected'=>$v, 'actual'=>(bool)$actual[$k]];
                }
            }
        }

        $data = [
          'ok'          => (bool)($j['ok'] ?? false),
          'php'         => $j['php_version'] ?? null,
          'site_url'    => $j['site_url'] ?? ($t['domain'] ?? null),
          'subscription_type' => $j['subscription_type'] ?? null,
          'subscription_end'  => $j['subscription_end'] ?? null,
          'modules_expected'  => $expected,
          'modules_actual'    => $actual,
          'modules_diff'      => $diff,
          'raw'               => $j,
        ];

    } else {
        // --- DB MODU ---
        $dsn = "mysql:host={$t['db_host']};port={$t['db_port']};dbname={$t['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $t['db_user'], $t['db_pass'], [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        $pdo->query("SELECT 1");

        // Sorgulanacak Config Key'leri Registry'den topla
        $configKeys = [];
        foreach ($registry as $cfg) {
            $configKeys[] = $cfg['config_key'];
        }
        // Ekstra sistem keyleri
        $sysKeys = ['SUBSCRIPTION_TYPE','SUBSCRIPTION_END','LAST_CRON_DAILY','LAST_CRON_HOURLY','SITE_URL'];
        
        $allKeys = array_merge($sysKeys, $configKeys);
        
        // Dinamik IN clause
        $in  = implode(',', array_fill(0, count($allKeys), '?'));
        $st  = $pdo->prepare("SELECT k,v FROM app_settings WHERE k IN ($in)");
        $st->execute($allKeys);
        $app = $st->fetchAll(PDO::FETCH_KEY_PAIR);

        // Actual durumunu oluştur
        $actual = [];
        foreach ($registry as $key => $cfg) {
            $k = $cfg['config_key'];
            $apiField = $cfg['api_field'];
            $actual[$apiField] = (isset($app[$k]) && (string)$app[$k] === '1');
        }

        $diff = [];
        foreach ($expected as $k=>$v) {
            if ((bool)$actual[$k] !== (bool)$v) {
                $diff[$k] = ['expected'=>$v, 'actual'=>(bool)$actual[$k]];
            }
        }

        $data = [
          'ok'                => true,
          'php_version'       => PHP_VERSION,
          'db'                => true,
          'site_url'          => $app['SITE_URL'] ?? $t['domain'],
          'subscription_type' => $app['SUBSCRIPTION_TYPE'] ?? ($t['subscription_type'] ?? 'free'),
          'subscription_end'  => $app['SUBSCRIPTION_END']  ?? ($t['subscription_end'] ?? null),
          'cron' => [
            'last_daily'  => $app['LAST_CRON_DAILY']  ?? null,
            'last_hourly' => $app['LAST_CRON_HOURLY'] ?? null,
          ],
          'modules_expected'  => $expected,
          'modules_actual'    => $actual,
          'modules_diff'      => $diff,
        ];
    }
} catch (Throwable $e) {
    $err = $e->getMessage();
}

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Health: <?= h($t['name']) ?></h3>
  <a class="btn btn-secondary" href="<?= h(base_url('tenants/index.php')) ?>"><i class="bi bi-arrow-left"></i> Geri</a>
</div>

<?php if ($err): ?>
  <div class="alert alert-danger">Hata: <?= h($err) ?></div>
<?php else: ?>
  <div class="card">
    <div class="card-body">
      <pre class="bg-light p-3 border rounded" style="white-space:pre-wrap"><?= h(json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) ?></pre>
    </div>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>