<?php
require_once __DIR__ . '/../includes/auth.php';
$active    = 'tenants';
$pageTitle = 'Tenant Düzenle';

$db     = hub_db();
$id     = (int)($_GET['id'] ?? 0);
$tenant = get_tenant($id);
if (!$tenant) { http_response_code(404); echo "Tenant yok"; exit; }

$registry = hub_modules_registry();
$err = '';

/**
 * Uzak (tenant) DB'den modül durumlarını okuyup,
 * $tenant içindeki module_... kolonlarını override eder.
 */
if (!function_exists('_hub_sync_tenant_modules_from_remote')) {
    function _hub_sync_tenant_modules_from_remote(array $tenant, array $registry): array
    {
        $host = $tenant['db_host'] ?? '';
        $name = $tenant['db_name'] ?? '';
        $user = $tenant['db_user'] ?? '';
        if (!$host || !$name || !$user) {
            return $tenant; // bağlantı için yeterli bilgi yok
        }

        try {
            $port = (int)($tenant['db_port'] ?? 3306);
            $pass = $tenant['db_pass'] ?? '';
            $dsn  = "mysql:host={$host};port={$port};dbname={$name};charset=utf8mb4";

            $pdo = new PDO($dsn, $user, $pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            ]);

            foreach ($registry as $key => $cfg) {
                $col = $cfg['tenant_column'] ?? null;
                if (!$col) { continue; }

                // 1) Önce module_flags'tan oku
                $stmt = $pdo->prepare("SELECT is_enabled FROM module_flags WHERE module_key = ? LIMIT 1");
                $stmt->execute([$key]);
                $row = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($row && array_key_exists('is_enabled', $row)) {
                    $tenant[$col] = (int)$row['is_enabled'] ? 1 : 0;
                    continue;
                }

                // 2) Fallback: app_settings (config_key veya MODULE_XXX)
                $configKey = $cfg['config_key'] ?? ('MODULE_' . strtoupper($key));
                $stmt2 = $pdo->prepare("SELECT v FROM app_settings WHERE k = ? LIMIT 1");
                $stmt2->execute([$configKey]);
                $row2 = $stmt2->fetch(PDO::FETCH_ASSOC);

                if ($row2 && array_key_exists('v', $row2)) {
                    $tenant[$col] = ((int)$row2['v']) ? 1 : 0;
                }
                // Eğer buradan da çıkmazsa, yakın DB'deki değer olduğu gibi kalır.
            }
        } catch (Throwable $e) {
            // Uzak DB'ye bağlanamazsa sessizce yutuyoruz; form yine de açılabilsin.
        }

        return $tenant;
    }
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err = 'Güvenlik doğrulaması başarısız.';
    } else {
        try {
            $p = $_POST;

            if (!empty($p['regen_api_key'])) {
                $p['api_key'] = generate_api_key();
                flash_set('ok','API Key yenilendi.');
            }

            // 1. AdminHub DB Güncelleme
            // NOT: module_ ön ekli kolonlar artık burada GÜNCELLENMİYOR.
            $sets = [
                "name=?", "domain=?", "db_host=?", "db_port=?", "db_name=?", "db_user=?", "db_pass=?",
                "subscription_type=?", "subscription_end=?",
            ];
            $args = [
                $p['name'], $p['domain'], $p['db_host'], (int)$p['db_port'], $p['db_name'], $p['db_user'], $p['db_pass'],
                $p['subscription_type'] ?? 'free', ($p['subscription_end'] ?? '') ?: null,
            ];

            $sets[] = "apply_method=?";
            $sets[] = "api_base_url=?";
            $sets[] = "api_key=?";
            $sets[] = "is_active=?";
            
            $args[] = $p['apply_method'] ?? 'db';
            $args[] = ($p['api_base_url'] ?? '') ?: null;
            $args[] = ($p['api_key'] ?? '') ?: null;
            $args[] = isset($p['is_active']) ? 1 : 0;
            
            $args[] = $id;

            $sql = "UPDATE tenants SET " . implode(', ', $sets) . " WHERE id=?";
            $st = $db->prepare($sql);
            $st->execute($args);

            // --- Tenant DB Bağlantısı ve Güncelleme ---
            // Sadece yöntem 'db' ise doğrudan bağlantı kurup yazarız
            if (($p['apply_method'] ?? 'db') === 'db') {
                try {
                    $dsn = "mysql:host={$p['db_host']};port={$p['db_port']};dbname={$p['db_name']};charset=utf8mb4";
                    $tenantDb = new PDO($dsn, $p['db_user'], $p['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

                    foreach ($registry as $key => $cfg) {
                        $isEnabled = isset($p['module_'.$key]) ? 1 : 0;
                        $configKey = $cfg['config_key'] ?? 'MODULE_'.strtoupper($key);

                        // A) app_settings güncelle
                        $stmtApp = $tenantDb->prepare("INSERT INTO app_settings (k, v) VALUES (?, ?) ON DUPLICATE KEY UPDATE v=VALUES(v)");
                        $stmtApp->execute([$configKey, (string)$isEnabled]);

                        // B) module_flags güncelle (is_enabled 1 veya 0 yap)
                        $stmtFlag = $tenantDb->prepare("INSERT INTO module_flags (module_key, is_enabled) VALUES (?, ?) ON DUPLICATE KEY UPDATE is_enabled=VALUES(is_enabled)");
                        $stmtFlag->execute([$key, $isEnabled]);
                    }
                } catch (Throwable $e) {
                    $err = "AdminHub güncellendi ancak Tenant DB'ye yazılamadı: " . $e->getMessage();
                }
            }

            if (!$err) {
                // Non-module alanları AdminHub DB'den taze çek
                $tenant = get_tenant($id);
                flash_set('ok','Güncellendi ve Tenant DB eşitlendi.');
            }
        } catch(Throwable $e) { $err = $e->getMessage(); }
    }
}

/**
 * SAYFA RENDER EDİLMEDEN ÖNCE:
 * Modül checkbox'larını uzak DB'den gelen gerçek duruma göre güncelle.
 */
$tenant = _hub_sync_tenant_modules_from_remote($tenant, $registry);

include __DIR__ . '/../includes/header.php';
?>
<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center">
    <strong>Tenant Düzenle</strong>
    <div class="d-flex gap-2">
      <form method="post" onsubmit="return confirm('API Key yenilensin mi?');">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <input type="hidden" name="name" value="<?= h($tenant['name']) ?>">
        <input type="hidden" name="domain" value="<?= h($tenant['domain']) ?>">
        <input type="hidden" name="db_host" value="<?= h($tenant['db_host']) ?>">
        <input type="hidden" name="db_port" value="<?= (int)$tenant['db_port'] ?>">
        <input type="hidden" name="db_name" value="<?= h($tenant['db_name']) ?>">
        <input type="hidden" name="db_user" value="<?= h($tenant['db_user']) ?>">
        <input type="hidden" name="db_pass" value="<?= h($tenant['db_pass']) ?>">
        <input type="hidden" name="subscription_type" value="<?= h($tenant['subscription_type']) ?>">
        <input type="hidden" name="subscription_end" value="<?= h($tenant['subscription_end']) ?>">
        <?php foreach($registry as $key => $cfg): 
            $col = $cfg['tenant_column'];
            if ((int)($tenant[$col] ?? 0)) echo '<input type="hidden" name="module_'.$key.'" value="1">';
        endforeach; ?>
        <input type="hidden" name="apply_method" value="<?= h($tenant['apply_method']) ?>">
        <input type="hidden" name="api_base_url" value="<?= h($tenant['api_base_url']) ?>">
        <input type="hidden" name="api_key" value="<?= h($tenant['api_key']) ?>">
        <input type="hidden" name="is_active" value="<?= (int)$tenant['is_active'] ? '1' : '0' ?>">
        
        <input type="hidden" name="regen_api_key" value="1">
        <button class="btn btn-warning btn-sm" type="submit"><i class="bi bi-key"></i> API Key’i Yenile</button>
      </form>
      <a class="btn btn-success btn-sm" href="<?= h(base_url('tenants/apply.php?id='.$tenant['id'])) ?>"><i class="bi bi-check2-circle"></i> Şimdi Uygula</a>
    </div>
  </div>
  <div class="card-body">
    <?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>
    <form method="post" class="row g-3">
      <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
      
      <div class="col-md-4"><label class="form-label">Ad</label><input name="name" class="form-control" value="<?=h($tenant['name'])?>" required></div>
      <div class="col-md-8"><label class="form-label">Domain</label><input name="domain" class="form-control" value="<?=h($tenant['domain'])?>" required></div>

      <h5 class="mt-4">Tenant DB</h5>
      <div class="col-md-4"><label class="form-label">Host</label><input name="db_host" class="form-control" value="<?=h($tenant['db_host'])?>" required></div>
      <div class="col-md-2"><label class="form-label">Port</label><input name="db_port" type="number" class="form-control" value="<?= (int)$tenant['db_port'] ?>" required></div>
      <div class="col-md-3"><label class="form-label">DB Name</label><input name="db_name" class="form-control" value="<?=h($tenant['db_name'])?>" required></div>
      <div class="col-md-3"><label class="form-label">DB User</label><input name="db_user" class="form-control" value="<?=h($tenant['db_user'])?>" required></div>
      <div class="col-md-6"><label class="form-label">DB Pass</label><input name="db_pass" type="password" class="form-control" value="<?=h($tenant['db_pass'])?>" required></div>

      <h5 class="mt-4">Abonelik</h5>
      <div class="col-md-3">
        <label class="form-label">Tip</label>
        <select name="subscription_type" class="form-select">
          <?php foreach(['free','basic','pro'] as $t): ?>
            <option value="<?=$t?>" <?= $tenant['subscription_type']===$t ? 'selected':'' ?>><?=$t?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3"><label class="form-label">Bitiş (ops.)</label><input type="date" name="subscription_end" class="form-control" value="<?=h($tenant['subscription_end'])?>"></div>

      <h5 class="mt-4">Modüller</h5>
      <?php foreach($registry as $key => $cfg): 
          $col = $cfg['tenant_column'];
          $chk = (int)($tenant[$col] ?? 0) ? 'checked':'';
          $lbl = $cfg['label'] ?? strtoupper($key);
      ?>
        <div class="col-md-3 form-check">
          <input class="form-check-input" type="checkbox" name="module_<?= $key ?>" id="m_<?= $key ?>" <?= $chk ?>>
          <label class="form-check-label" for="m_<?= $key ?>"><?= h($lbl) ?></label>
        </div>
      <?php endforeach; ?>

      <h5 class="mt-4">Uygulama Yöntemi / API</h5>
      <div class="col-md-3">
        <label class="form-label">Yöntem</label>
        <select name="apply_method" class="form-select">
          <option value="db"  <?= $tenant['apply_method']==='db'  ? 'selected':'' ?>>DB (doğrudan)</option>
          <option value="api" <?= $tenant['apply_method']==='api' ? 'selected':'' ?>>API</option>
        </select>
      </div>
      <div class="col-md-5"><label class="form-label">API Base URL</label><input name="api_base_url" class="form-control" value="<?=h($tenant['api_base_url'])?>"></div>
      <div class="col-md-4">
        <label class="form-label">API Key</label>
        <div class="input-group">
          <input name="api_key" class="form-control" value="<?=h($tenant['api_key'])?>" placeholder="sk-...">
          <span class="input-group-text" onclick="navigator.clipboard.writeText('<?= h($tenant['api_key']) ?>')" style="cursor:pointer"><i class="bi bi-clipboard"></i></span>
        </div>
      </div>

      <div class="col-12 form-check mt-3">
        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= (int)$tenant['is_active'] ? 'checked':'' ?>>
        <label class="form-check-label" for="is_active">Aktif</label>
      </div>

      <div class="col-12 mt-3 d-flex gap-2">
        <button class="btn btn-primary">Kaydet</button>
        <a class="btn btn-secondary" href="<?= h(base_url('tenants/index.php')) ?>">Geri</a>
        <a class="btn btn-success" href="<?= h(base_url('tenants/apply.php?id='.$tenant['id'])) ?>">Şimdi Uygula</a>
      </div>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
