<?php
// tenants/apply.php
require_once __DIR__ . '/../includes/auth.php'; // functions.php'yi ve dolayısıyla registry'yi yükler

$db = hub_db();
$id = (int)($_GET['id'] ?? 0);

if ($id <= 0) {
    flash_set('err','Geçersiz istek.');
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}

$t  = get_tenant($id);
if (!$t) {
    http_response_code(404);
    echo "Tenant yok";
    exit;
}

if (!(int)$t['is_active']) {
    flash_set('err','Tenant pasif.');
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}

try {
    $method = (string)($t['apply_method'] ?? 'db');

    if ($method === 'api') {
        apply_by_api($t); // functions.php içinde dinamik
    } else {
        apply_by_db($t);  // functions.php içinde dinamik
    }

    $db->prepare("UPDATE tenants SET last_applied_at = NOW() WHERE id = ?")->execute([$id]);

    log_tenant($id, 'apply', 'success', 'Ayarlar uygulandı (yöntem: ' . $method . ')');
    flash_set('ok','Ayarlar uygulandı (yöntem: ' . h($method) . ').');
    header('Location: ' . base_url('tenants/index.php'));
    exit;

} catch (Throwable $e) {
    log_tenant($id, 'apply', 'error', $e->getMessage());
    flash_set('err','Hata: ' . $e->getMessage());
    header('Location: ' . base_url('tenants/index.php'));
    exit;
}
