<?php
require_once __DIR__ . '/../includes/functions.php';
$c = hub_config();
$db = hub_db();

$registry = hub_modules_registry();
$err = '';

if ($_SERVER['REQUEST_METHOD']==='POST') {
    try {
        $p = $_POST;

        $subscription_end = ($p['subscription_end'] ?? '') ?: null;
        $api_base_url     = ($p['api_base_url'] ?? '') ?: null;
        $api_key          = ($p['api_key'] ?? '') ?: null;
        $apply_method     = $p['apply_method'] ?? 'db';

        if ($apply_method === 'api' && $api_key === '') {
            $api_key = generate_api_key();
            flash_set('ok', 'API Key otomatik üretildi.');
        }

        // 1. AdminHub DB'ye Ekleme
        // NOT: module_ ön ekli kolonlara artık DEĞER YAZMIYORUZ.
        $cols = [
            'name', 'domain', 'db_host', 'db_port', 'db_name', 'db_user', 'db_pass',
            'subscription_type', 'subscription_end'
        ];
        $vals = [
            $p['name'], $p['domain'], $p['db_host'], (int)$p['db_port'], $p['db_name'], $p['db_user'], $p['db_pass'],
            $p['subscription_type'] ?? 'free', $subscription_end
        ];

        // Eskiden buradaydı:
        // foreach ($registry as $key => $cfg) {
        //     $cols[] = $cfg['tenant_column'];
        //     $vals[] = isset($p['module_'.$key]) ? 1 : 0;
        // }

        $cols = array_merge($cols, ['apply_method', 'api_base_url', 'api_key', 'is_active']);
        $vals = array_merge($vals, [$apply_method, $api_base_url, $api_key ?: null, isset($p['is_active']) ? 1 : 0]);

        $colStr = implode(', ', $cols);
        $valStr = implode(', ', array_fill(0, count($cols), '?'));
        
        $sql = "INSERT INTO tenants ($colStr) VALUES ($valStr)";
        $st = $db->prepare($sql);
        $st->execute($vals);

        // --- Tenant DB Bağlantısı ve Güncelleme ---
        if ($apply_method === 'db') {
            try {
                // Tenant veritabanına bağlanmayı dene
                $dsn = "mysql:host={$p['db_host']};port={$p['db_port']};dbname={$p['db_name']};charset=utf8mb4";
                $tenantDb = new PDO($dsn, $p['db_user'], $p['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

                // Modül ayarlarını işle (SADECE UZAK DB)
                foreach ($registry as $key => $cfg) {
                    $isEnabled = isset($p['module_'.$key]) ? 1 : 0;
                    $configKey = $cfg['config_key'] ?? 'MODULE_'.strtoupper($key);

                    // A) app_settings güncelle
                    $stmtApp = $tenantDb->prepare("INSERT INTO app_settings (k, v) VALUES (?, ?) ON DUPLICATE KEY UPDATE v=VALUES(v)");
                    $stmtApp->execute([$configKey, (string)$isEnabled]);

                    // B) module_flags güncelle
                    $stmtFlag = $tenantDb->prepare("INSERT INTO module_flags (module_key, is_enabled) VALUES (?, ?) ON DUPLICATE KEY UPDATE is_enabled=VALUES(is_enabled)");
                    $stmtFlag->execute([$key, $isEnabled]);
                }
            } catch (Throwable $e) {
                // Tenant DB'si henüz yoksa veya erişilemiyorsa burası çalışır.
                // Yeni tenant eklerken bu normal olabilir, o yüzden ana işlemi durdurmuyoruz.
                // İstersen loglayabilirsin:
                // error_log("Tenant DB erişim hatası: " . $e->getMessage());
            }
        }
        // -----------------------------------------------------------

        header('Location: index.php');
        exit;
    } catch(Throwable $e) {
        $err = $e->getMessage();
    }
}

include __DIR__ . '/../includes/header.php';
?>

<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Yeni Tenant</h3>
    <a class="btn btn-secondary" href="index.php">Geri</a>
  </div>

  <?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-md-4"><label class="form-label">Ad</label><input name="name" class="form-control" required></div>
    <div class="col-md-8"><label class="form-label">Domain</label><input name="domain" class="form-control" placeholder="https://fatura.ornek.com" required></div>

    <h5 class="mt-4">Tenant DB</h5>
    <div class="col-md-4"><label class="form-label">Host</label><input name="db_host" class="form-control" value="127.0.0.1" required></div>
    <div class="col-md-2"><label class="form-label">Port</label><input name="db_port" type="number" class="form-control" value="3306" required></div>
    <div class="col-md-3"><label class="form-label">DB Name</label><input name="db_name" class="form-control" required></div>
    <div class="col-md-3"><label class="form-label">DB User</label><input name="db_user" class="form-control" required></div>
    <div class="col-md-6"><label class="form-label">DB Pass</label><input name="db_pass" type="password" class="form-control" required></div>

    <h5 class="mt-4">Abonelik</h5>
    <div class="col-md-3">
      <label class="form-label">Tip</label>
      <select name="subscription_type" class="form-select">
        <option value="free">free</option>
        <option value="basic">basic</option>
        <option value="pro">pro</option>
      </select>
    </div>
    <div class="col-md-3"><label class="form-label">Bitiş (ops.)</label><input type="date" name="subscription_end" class="form-control"></div>

    <h5 class="mt-4">Modüller</h5>
    <?php foreach($registry as $key => $cfg): 
        $defaultOn = ['invoices', 'customers', 'products']; 
        $chk = in_array($key, $defaultOn) ? 'checked' : '';
        $lbl = $cfg['label'] ?? strtoupper($key);
    ?>
      <div class="col-md-3 form-check">
        <input class="form-check-input" type="checkbox" name="module_<?= $key ?>" id="m_<?= $key ?>" <?= $chk ?>>
        <label class="form-check-label" for="m_<?= $key ?>"><?= h($lbl) ?></label>
      </div>
    <?php endforeach; ?>

    <h5 class="mt-4">Uygulama Yöntemi / API</h5>
    <div class="col-md-3">
      <label class="form-label">Yöntem</label>
      <select name="apply_method" class="form-select">
        <option value="db">DB (doğrudan)</option>
        <option value="api">API</option>
      </select>
    </div>
    <div class="col-md-5"><label class="form-label">API Base URL</label><input name="api_base_url" class="form-control"></div>
    <div class="col-md-4"><label class="form-label">API Key</label><input name="api_key" class="form-control" placeholder="sk-..."></div>

    <div class="col-12 form-check mt-3">
      <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
      <label class="form-check-label" for="is_active">Aktif</label>
    </div>

    <div class="col-12 mt-3">
      <button class="btn btn-primary">Kaydet</button>
      <a class="btn btn-secondary" href="index.php">Geri</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
