<?php
// adminhub/save_menu.php
header('Content-Type: application/json');

// Session kontrolü vs. burada yapılmalı

// JSON verisini al
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!$data) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz veri.']);
    exit;
}

// Dosya yolu (Örnek: adminhub/data/menu.json veya ortak bir alan)
// Tenantların erişebileceği bir yere kopyalaman veya senkronizasyon yapman gerekecek.
// Şimdilik adminhub içinde bir "data" klasörüne kaydediyoruz.
$savePath = __DIR__ . '/data/menu.json';
$dir = dirname($savePath);

if (!is_dir($dir)) {
    mkdir($dir, 0777, true);
}

// Dosyayı kaydet
if (file_put_contents($savePath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
    echo json_encode(['success' => true, 'message' => 'Dosya kaydedildi.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Dosya yazılamadı. İzinleri kontrol edin.']);
}