<?php
// adminhub/includes/modules_registry.php

if (!function_exists('hub_modules_registry')) {
    function hub_modules_registry(): array {
        // 1. JSON dosyasını kontrol et
        $jsonFile = __DIR__ . '/includes/modules_registry.json';
        
        if (file_exists($jsonFile)) {
            $content = file_get_contents($jsonFile);
            $json = json_decode($content, true);
            if (is_array($json)) {
                return $json;
            }
        }

        // 2. JSON yoksa (ilk kurulum), varsayılan çekirdek modülleri döndür
        return [
            'invoices' => [
                'label'         => 'INVOICES',
                'tenant_column' => 'module_invoices',
                'config_key'    => 'MODULE_INVOICES',
                'api_field'     => 'invoices',
            ],
            'customers' => [
                'label'         => 'CUSTOMERS',
                'tenant_column' => 'module_customers',
                'config_key'    => 'MODULE_CUSTOMERS',
                'api_field'     => 'customers',
            ],
            // ... Sistem çalışsın diye en azından temel modüller burada kalsın
            'products' => [ 'label' => 'PRODUCTS', 'tenant_column' => 'module_products', 'config_key' => 'MODULE_PRODUCTS', 'api_field' => 'products' ],
        ];
    }
}

// ... Dosyanın geri kalanı (helper fonksiyonlar) AYNI kalacak ...
if (!function_exists('hub_module_keys')) {
    function hub_module_keys(): array {
        return array_keys(hub_modules_registry());
    }
}

if (!function_exists('module_config_key')) {
    function module_config_key(string $key): string {
        $mods = hub_modules_registry();
        return $mods[$key]['config_key'] ?? 'MODULE_' . strtoupper($key);
    }
}

if (!function_exists('module_column_name')) {
    function module_column_name(string $key): string {
        $mods = hub_modules_registry();
        return $mods[$key]['tenant_column'] ?? 'module_' . strtolower($key);
    }
}

if (!function_exists('module_label')) {
    function module_label(string $key): string {
        $mods = hub_modules_registry();
        return $mods[$key]['label'] ?? strtoupper(str_replace('_', ' ', $key));
    }
}

if (!function_exists('module_api_field')) {
    function module_api_field(string $key): string {
        $mods = hub_modules_registry();
        return $mods[$key]['api_field'] ?? $key;
    }
}