<?php
// adminhub/menu_builder.php
// Admin yetki kontrolü burada olmalı (session check vs.)

$message = '';
$menuFile = __DIR__ . '/data/menu.json'; // Kaydedilecek/Okunacak dosya yolu (Klasör yapına göre ayarla)
$currentMenuData = file_exists($menuFile) ? file_get_contents($menuFile) : '[]';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Menü Oluşturucu - AdminHub</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" />
    
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    
    <style>
        .menu-builder-container { display: flex; gap: 20px; }
        .menu-editor { flex: 1; border-right: 1px solid #ddd; padding-right: 20px; }
        .menu-preview { flex: 2; background: #f8f9fa; padding: 20px; border-radius: 8px; }
        
        /* Liste Stilleri */
        .dd-list { list-style: none; padding: 0; min-height: 50px; }
        .dd-item { 
            background: #fff; border: 1px solid #ddd; margin-bottom: 5px; padding: 10px; 
            border-radius: 4px; cursor: move; position: relative;
        }
        .dd-item .item-content { display: flex; align-items: center; justify-content: space-between; }
        .dd-item .item-details { font-size: 0.9em; color: #666; margin-left: 10px; }
        .dd-item .badge-mod { background: #eef2ff; color: #4f46e5; border: 1px solid #c7d2fe; padding: 2px 6px; border-radius: 4px; font-size: 0.75em; }
        
        /* İç içe liste padding */
        .dd-list .dd-list { padding-left: 30px; margin-top: 10px; border-left: 2px dashed #ddd; }
        
        .remove-btn { color: red; cursor: pointer; margin-left: 10px; }
        .handle { cursor: grab; margin-right: 10px; color: #aaa; }
    </style>
</head>
<body>

<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="bi bi-diagram-3"></i> Menü Oluşturucu</h2>
        <div>
            <button id="saveMenuBtn" class="btn btn-success"><i class="bi bi-save"></i> Menüyü Kaydet</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-primary text-white">Yeni Öğe Ekle</div>
                <div class="card-body">
                    <form id="addUpdateForm">
                        <div class="mb-3">
                            <label>Tip</label>
                            <select id="itemType" class="form-select">
                                <option value="link">Link (Tekil Sayfa)</option>
                                <option value="dropdown">Dropdown (Alt Menü Başlığı)</option>
                                <option value="header">Başlık (Header)</option>
                                <option value="divider">Ayırıcı Çizgi (Divider)</option>
                            </select>
                        </div>

                        <div class="mb-3" id="groupLabel">
                            <label>Görünen İsim (Label)</label>
                            <input type="text" id="itemLabel" class="form-control" placeholder="Örn: Siparişler">
                        </div>

                        <div class="mb-3" id="groupUrl">
                            <label>URL</label>
                            <input type="text" id="itemUrl" class="form-control" placeholder="/modules/orders/list.php">
                        </div>

                        <div class="mb-3" id="groupIcon">
                            <label>İkon (Bootstrap Icons)</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-star"></i></span>
                                <input type="text" id="itemIcon" class="form-control" placeholder="bi bi-basket">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label>Modül Anahtarı (Module Key)</label>
                            <input type="text" id="itemModule" class="form-control" placeholder="Örn: orders (Boşsa herkese görünür)">
                            <small class="text-muted">Bu modül kapalıysa menü gizlenir.</small>
                        </div>
                        
                        <div class="mb-3" id="groupActiveKey">
                            <label>Active Key (Kod tarafı için)</label>
                            <input type="text" id="itemActiveKey" class="form-control" placeholder="Örn: orders_list">
                        </div>

                        <button type="button" id="addItemBtn" class="btn btn-primary w-100">Listeye Ekle</button>
                    </form>
                </div>
            </div>
            
            <div class="alert alert-info mt-3">
                <small>
                    <i class="bi bi-info-circle"></i> İpucu: Öğeleri sürükleyip bırakarak sıralayabilirsiniz. 
                    Bir öğeyi başka bir öğenin içine sürükleyerek (sağa doğru kaydırarak değil, altına bırakarak) alt menü oluşturabilirsiniz.
                    <strong>Not:</strong> Dropdown tipindeki öğelerin altına sürükleyiniz.
                </small>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Menü Yapısı</div>
                <div class="card-body bg-light">
                    <ul id="menuTree" class="dd-list">
                        </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    var initialMenuData = <?= $currentMenuData ?>;
</script>

<script>
    // --- 1. SÜRÜKLE BIRAK MANTIĞI (SortableJS) ---
    function initSortable() {
        var nestedSortables = [].slice.call(document.querySelectorAll('.dd-list'));

        for (var i = 0; i < nestedSortables.length; i++) {
            new Sortable(nestedSortables[i], {
                group: 'nested',
                animation: 150,
                fallbackOnBody: true,
                swapThreshold: 0.65,
                handle: '.handle' // Sadece ikon tutulunca taşınsın
            });
        }
    }

    // --- 2. HTML OLUŞTURUCU ---
    function createMenuItemHtml(item) {
        let iconHtml = item.icon ? `<i class="${item.icon}"></i> ` : '';
        let moduleBadge = item.module_key ? `<span class="badge-mod">${item.module_key}</span>` : '';
        
        let displayTitle = item.label;
        if(item.type === 'divider') displayTitle = '<hr class="m-0" style="width:50px; display:inline-block">';
        if(item.type === 'header') displayTitle = `<strong>${item.label}</strong> (Başlık)`;

        let html = `
        <li class="dd-item" 
            data-type="${item.type}" 
            data-label="${item.label || ''}" 
            data-url="${item.url || ''}" 
            data-icon="${item.icon || ''}" 
            data-module="${item.module_key || ''}" 
            data-active="${item.active_key || ''}">
            
            <div class="item-content">
                <div>
                    <span class="handle"><i class="bi bi-grip-vertical"></i></span>
                    ${iconHtml} <span>${displayTitle}</span>
                    ${moduleBadge}
                </div>
                <div>
                    <span class="remove-btn" onclick="this.closest('li').remove()"><i class="bi bi-trash"></i></span>
                </div>
            </div>
            
            <ul class="dd-list">
                ${item.children ? item.children.map(child => createMenuItemHtml(child)).join('') : ''}
            </ul>
        </li>`;
        return html;
    }

    // --- 3. SAYFA YÜKLENDİĞİNDE ---
    document.addEventListener('DOMContentLoaded', function() {
        const rootList = document.getElementById('menuTree');
        
        // Kayıtlı veriyi yükle
        if (initialMenuData && initialMenuData.length > 0) {
            rootList.innerHTML = initialMenuData.map(item => createMenuItemHtml(item)).join('');
        }
        
        initSortable(); // İlk başlatma

        // Form Tipi Değişince Alanları Gizle/Göster
        document.getElementById('itemType').addEventListener('change', function() {
            const val = this.value;
            const groupUrl = document.getElementById('groupUrl');
            const groupLabel = document.getElementById('groupLabel');
            const groupIcon = document.getElementById('groupIcon');
            const groupActive = document.getElementById('groupActiveKey');

            if(val === 'divider') {
                groupUrl.style.display = 'none';
                groupLabel.style.display = 'none';
                groupIcon.style.display = 'none';
                groupActive.style.display = 'none';
            } else if(val === 'header') {
                groupUrl.style.display = 'none';
                groupLabel.style.display = 'block';
                groupIcon.style.display = 'none';
                groupActive.style.display = 'none';
            } else if(val === 'dropdown') {
                groupUrl.style.display = 'none'; // Dropdown'ın kendisine genelde link verilmez
                groupLabel.style.display = 'block';
                groupIcon.style.display = 'block';
                groupActive.style.display = 'none';
            } else {
                // Link
                groupUrl.style.display = 'block';
                groupLabel.style.display = 'block';
                groupIcon.style.display = 'block';
                groupActive.style.display = 'block';
            }
        });

        // "Ekle" Butonu
        document.getElementById('addItemBtn').addEventListener('click', function() {
            const item = {
                type: document.getElementById('itemType').value,
                label: document.getElementById('itemLabel').value,
                url: document.getElementById('itemUrl').value,
                icon: document.getElementById('itemIcon').value,
                module_key: document.getElementById('itemModule').value,
                active_key: document.getElementById('itemActiveKey').value,
                children: []
            };

            // HTML oluştur ve listeye ekle
            const html = createMenuItemHtml(item);
            document.getElementById('menuTree').insertAdjacentHTML('beforeend', html);
            
            // Yeni eklenen öğe için de sortable'ı tetikle (veya refresh et)
            initSortable();
            
            // Formu temizle
            document.getElementById('addUpdateForm').reset();
        });

        // "KAYDET" Butonu - JSON Serialization
        document.getElementById('saveMenuBtn').addEventListener('click', function() {
            const json = serializeMenu(document.getElementById('menuTree'));
            // AJAX ile gönder
            fetch('save_menu.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify(json)
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    alert('Menü başarıyla kaydedildi!');
                } else {
                    alert('Hata: ' + data.message);
                }
            })
            .catch(err => alert('Bir hata oluştu.'));
        });
    });

    // --- 4. HTML -> JSON ÇEVİRİCİ (Recursive) ---
    function serializeMenu(listElement) {
        let result = [];
        // listElement bir <ul>'dur. Onun doğrudan çocukları olan <li>'leri al.
        let items = listElement.querySelectorAll(':scope > li'); 
        
        items.forEach(li => {
            let item = {
                type: li.dataset.type,
                label: li.dataset.label,
                url: li.dataset.url,
                icon: li.dataset.icon,
                module_key: li.dataset.module,
                active_key: li.dataset.active
            };
            
            // Alt liste var mı?
            let subUl = li.querySelector(':scope > ul');
            if (subUl && subUl.children.length > 0) {
                let children = serializeMenu(subUl);
                if (children.length > 0) {
                    item.children = children;
                }
            }
            
            result.push(item);
        });
        return result;
    }
</script>

</body>
</html>