<?php
require_once __DIR__ . '/../includes/auth.php';
$active    = 'tenants';
$pageTitle = 'Tenant Düzenle';

$db     = hub_db();
$id     = (int)($_GET['id'] ?? 0);
$tenant = get_tenant($id);
if (!$tenant) { http_response_code(404); echo "Tenant yok"; exit; }

$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err = 'Güvenlik doğrulaması başarısız.';
    } else {
        try {
            $p = $_POST;

            // API key yenileme isteği geldiyse üret
            if (!empty($p['regen_api_key'])) {
                $p['api_key'] = generate_api_key();
                flash_set('ok','API Key yenilendi.');
            }

            $st = $db->prepare("UPDATE tenants SET
              name=?, domain=?, db_host=?, db_port=?, db_name=?, db_user=?, db_pass=?,
              subscription_type=?, subscription_end=?,
              module_invoices=?, module_customers=?, module_products=?, module_inventory=?, module_production=?, module_personnel=?, module_crm=?, module_accounts=?, module_budget=?, module_cheques=?, module_expenses=?, module_tax=?, module_efatura=?, module_eirsaliye=?, module_irsaliye=?, module_deliveries=?, module_foreign_trade=?, module_orders=?, module_reports=?,
              apply_method=?, api_base_url=?, api_key=?, is_active=?
              WHERE id=?");
            $st->execute([
              $p['name'], $p['domain'], $p['db_host'], (int)$p['db_port'], $p['db_name'], $p['db_user'], $p['db_pass'],
              $p['subscription_type'] ?? 'free',
              ($p['subscription_end'] ?? '') ?: null,
              isset($p['module_invoices'])?1:0,
              isset($p['module_customers'])?1:0,
              isset($p['module_products'])?1:0,
              isset($p['module_inventory'])?1:0,
              isset($p['module_production'])?1:0,
              isset($p['module_personnel'])?1:0,
              isset($p['module_crm'])?1:0,
              isset($p['module_accounts'])?1:0,
              isset($p['module_budget'])?1:0,
              isset($p['module_cheques'])?1:0,
              isset($p['module_expenses'])?1:0,
              isset($p['module_tax'])?1:0,
              isset($p['module_efatura'])?1:0,
              isset($p['module_eirsaliye'])?1:0,
              isset($p['module_irsaliye'])?1:0,
              isset($p['module_deliveries'])?1:0,
              isset($p['module_foreign_trade'])?1:0,
              isset($p['module_orders'])?1:0, // << ORDERS eklendi
              isset($p['module_reports'])?1:0,
              $p['apply_method'] ?? 'db',
              ($p['api_base_url'] ?? '') ?: null,
              ($p['api_key'] ?? '') ?: null,
              isset($p['is_active'])?1:0,
              $id
            ]);
            $tenant = get_tenant($id);
            flash_set('ok','Güncellendi.');
        } catch(Throwable $e) { $err = $e->getMessage(); }
    }
}

include __DIR__ . '/../includes/header.php';
?>
<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center">
    <strong>Tenant Düzenle</strong>
    <div class="d-flex gap-2">
      <form method="post" onsubmit="return confirm('API Key yenilensin mi? Eski anahtar geçersiz olacaktır.');">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <!-- Diğer zorunlu alanları mevcut değerlerle gizli taşıyalım ki form bütünlüğü bozulmasın -->
        <input type="hidden" name="name" value="<?= h($tenant['name']) ?>">
        <input type="hidden" name="domain" value="<?= h($tenant['domain']) ?>">
        <input type="hidden" name="db_host" value="<?= h($tenant['db_host']) ?>">
        <input type="hidden" name="db_port" value="<?= (int)$tenant['db_port'] ?>">
        <input type="hidden" name="db_name" value="<?= h($tenant['db_name']) ?>">
        <input type="hidden" name="db_user" value="<?= h($tenant['db_user']) ?>">
        <input type="hidden" name="db_pass" value="<?= h($tenant['db_pass']) ?>">
        <input type="hidden" name="subscription_type" value="<?= h($tenant['subscription_type']) ?>">
        <input type="hidden" name="subscription_end" value="<?= h($tenant['subscription_end']) ?>">
        <?php
          $mods = [
            'invoices','customers','products','inventory','production','personnel','crm','accounts',
            'budget','cheques','expenses','tax','efatura','eirsaliye','irsaliye','deliveries','foreign_trade','orders','reports' // << ORDERS eklendi
          ];
          foreach($mods as $m):
            $col = 'module_'.$m;
            if ((int)$tenant[$col]) {
              echo '<input type="hidden" name="module_'.$m.'" value="1">';
            }
          endforeach;
        ?>
        <input type="hidden" name="apply_method" value="<?= h($tenant['apply_method']) ?>">
        <input type="hidden" name="api_base_url" value="<?= h($tenant['api_base_url']) ?>">
        <input type="hidden" name="api_key" value="<?= h($tenant['api_key']) ?>">
        <input type="hidden" name="is_active" value="<?= (int)$tenant['is_active'] ? '1' : '0' ?>">
        <input type="hidden" name="regen_api_key" value="1">
        <button class="btn btn-warning btn-sm" type="submit"><i class="bi bi-key"></i> API Key’i Yenile</button>
      </form>
      <a class="btn btn-success btn-sm" href="<?= h(base_url('tenants/apply.php?id='.$tenant['id'])) ?>"><i class="bi bi-check2-circle"></i> Şimdi Uygula</a>
    </div>
  </div>
  <div class="card-body">
    <?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>
    <form method="post" class="row g-3">
      <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
      <div class="col-md-4">
        <label class="form-label">Ad</label>
        <input name="name" class="form-control" value="<?=h($tenant['name'])?>" required>
      </div>
      <div class="col-md-8">
        <label class="form-label">Domain</label>
        <input name="domain" class="form-control" value="<?=h($tenant['domain'])?>" required>
      </div>

      <h5 class="mt-4">Tenant DB</h5>
      <div class="col-md-4"><label class="form-label">Host</label><input name="db_host" class="form-control" value="<?=h($tenant['db_host'])?>" required></div>
      <div class="col-md-2"><label class="form-label">Port</label><input name="db_port" type="number" class="form-control" value="<?= (int)$tenant['db_port'] ?>" required></div>
      <div class="col-md-3"><label class="form-label">DB Name</label><input name="db_name" class="form-control" value="<?=h($tenant['db_name'])?>" required></div>
      <div class="col-md-3"><label class="form-label">DB User</label><input name="db_user" class="form-control" value="<?=h($tenant['db_user'])?>" required></div>
      <div class="col-md-6"><label class="form-label">DB Pass</label><input name="db_pass" type="password" class="form-control" value="<?=h($tenant['db_pass'])?>" required></div>

      <h5 class="mt-4">Abonelik</h5>
      <div class="col-md-3">
        <label class="form-label">Tip</label>
        <select name="subscription_type" class="form-select">
          <?php foreach(['free','basic','pro'] as $t): ?>
            <option value="<?=$t?>" <?= $tenant['subscription_type']===$t ? 'selected':'' ?>><?=$t?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Bitiş (ops.)</label>
        <input type="date" name="subscription_end" class="form-control" value="<?=h($tenant['subscription_end'])?>">
      </div>

      <h5 class="mt-4">Modüller</h5>
      <?php
        $mods = [
          'invoices','customers','products','inventory','production','personnel','crm','accounts',
          'budget','cheques','expenses','tax','efatura','eirsaliye','irsaliye','deliveries','foreign_trade','orders','reports' // << ORDERS eklendi
        ];
        foreach($mods as $m):
          $col = 'module_'.$m;
          $chk = (int)$tenant[$col] ? 'checked':'';
      ?>
        <div class="col-md-3 form-check">
          <input class="form-check-input" type="checkbox" name="module_<?= $m ?>" id="m_<?= $m ?>" <?= $chk ?>>
          <label class="form-check-label" for="m_<?= $m ?>"><?= strtoupper(str_replace('_',' ',$m)) ?></label>
        </div>
      <?php endforeach; ?>

      <h5 class="mt-4">Uygulama Yöntemi / API</h5>
      <div class="col-md-3">
        <label class="form-label">Yöntem</label>
        <select name="apply_method" class="form-select">
          <option value="db"  <?= $tenant['apply_method']==='db'  ? 'selected':'' ?>>DB (doğrudan)</option>
          <option value="api" <?= $tenant['apply_method']==='api' ? 'selected':'' ?>>API (tenant/api/set_config.php)</option>
        </select>
      </div>
      <div class="col-md-5">
        <label class="form-label">API Base URL</label>
        <input name="api_base_url" class="form-control" value="<?=h($tenant['api_base_url'])?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">API Key</label>
        <div class="input-group">
          <input name="api_key" class="form-control" value="<?=h($tenant['api_key'])?>" placeholder="sk-...">
          <span class="input-group-text" title="Kopyala" style="cursor:pointer" onclick="navigator.clipboard.writeText('<?= h($tenant['api_key']) ?>')"><i class="bi bi-clipboard"></i></span>
        </div>
        <small class="text-muted">Anahtarı yenilersen karşı taraftaki lisans doğrulaması için yeni anahtarı kullanmalısın.</small>
      </div>

      <div class="col-12 form-check mt-3">
        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= (int)$tenant['is_active'] ? 'checked':'' ?>>
        <label class="form-check-label" for="is_active">Aktif</label>
      </div>

      <div class="col-12 mt-3 d-flex gap-2">
        <button class="btn btn-primary">Kaydet</button>
        <a class="btn btn-secondary" href="<?= h(base_url('tenants/index.php')) ?>">Geri</a>
        <a class="btn btn-success" href="<?= h(base_url('tenants/apply.php?id='.$tenant['id'])) ?>">Şimdi Uygula</a>
      </div>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
