<?php
// includes/payments.php
require_once __DIR__ . '/functions.php';

if (!function_exists('sum_invoice_payments')) {
    function sum_invoice_payments(int $invoiceId): float {
        $st = db()->prepare("SELECT COALESCE(SUM(amount),0) FROM invoice_payments WHERE invoice_id=?");
        $st->execute([$invoiceId]);
        return (float)$st->fetchColumn();
    }
}

if (!function_exists('try_mark_invoice_paid')) {
    // Fatura tablosunda total ve status alanı varsa 'paid' yapmaya çalışır; yoksa sessiz geçer.
    function try_mark_invoice_paid(int $invoiceId): void {
        try {
            $db = db();
            $st = $db->prepare("SELECT total FROM invoices WHERE id=? LIMIT 1");
            $st->execute([$invoiceId]);
            $total = $st->fetchColumn();
            if ($total === false) return;

            $paid = sum_invoice_payments($invoiceId);
            if ($paid + 0.0001 >= (float)$total) {
                $upd = $db->prepare("UPDATE invoices SET status='paid' WHERE id=?");
                $upd->execute([$invoiceId]);
            }
        } catch (Throwable $e) {
            // tablo/alan yoksa sessiz geç
        }
    }
}
