<?php
// AdminHub -> includes/header.php
if (!isset($pageTitle)) { $pageTitle = 'AdminHub'; }
$c   = hub_config();
$adm = current_admin();
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="robots" content="noindex,nofollow">
  <title><?= h($pageTitle) ?> - <?= h($c['SITE_NAME']) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body { background: #f6f8fb; }
    .navbar-brand { font-weight:700; letter-spacing:.2px; }
    .card { border: 0; box-shadow: 0 1px 2px rgba(0,0,0,.05); }
    .stat { border-radius: 12px; }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="<?= h(base_url('index.php')) ?>"><i class="bi bi-shield-lock"></i> <?= h($c['SITE_NAME']) ?></a>
    <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#nav"><span class="navbar-toggler-icon"></span></button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link<?= ($active ?? '')==='dashboard'?' active':'' ?>" href="<?= h(base_url('index.php')) ?>"><i class="bi bi-speedometer2"></i> Dashboard</a></li>
        <li class="nav-item"><a class="nav-link<?= ($active ?? '')==='tenants'?' active':'' ?>" href="<?= h(base_url('tenants/index.php')) ?>"><i class="bi bi-buildings"></i> Tenants</a></li>
      </ul>
      <ul class="navbar-nav ms-auto">
        <?php if ($adm): ?>
          <li class="nav-item"><span class="navbar-text me-3"><i class="bi bi-person-circle"></i> <?= h($adm['name']) ?></span></li>
          <li class="nav-item"><a class="nav-link" href="<?= h(base_url('auth/logout.php')) ?>"><i class="bi bi-box-arrow-right"></i> Çıkış</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<div class="container-fluid py-4">
<?php if ($msg = flash_get('ok')): ?>
  <div class="alert alert-success"><?= h($msg) ?></div>
<?php endif; ?>
<?php if ($msg = flash_get('err')): ?>
  <div class="alert alert-danger"><?= h($msg) ?></div>
<?php endif; ?>
